 ; Write entity data to a file in the form the drawing editor uses.
 ; Copyright 1992, 1996 by Rocket Software Ltd.
 ; Make your own DXf files.  (Or something like them.)
 ; Getting the information back into a drawing is your own problem.
 (DEFUN C:FILO (/ ss fn ff num enam entt)
  (write-line "Select entities to file: ")
  (setq ss (ssget))
  (if (/= "" (setq fn (getstring "Filename: ")))
      (progn
           (setq ff (open fn "w"))
           (close ff)
           (setq ff (open fn "a"))))
  (setq num 0)
  (while (and ff (setq enam (ssname ss num)))
         (setq entt (entget enam))                 ; get entity data
         (prin1 entt ff)                           ; write data to file
         (write-line "" ff)                        ; insert cr-lf
         (if (= (cdr (assoc 66 entt)) 1)           ; if entities follow
             (while (/= (cdr (assoc 0 (setq entt (entget
                                       (setq enam (entnext enam)))))) "SEQEND")
                    (princ "  " ff)                ; indent subentities
                    (prin1 entt ff)                ; write data to file
                    (write-line "" ff)))           ; insert cr-lf
         (setq num (1+ num)))                      ; next entity in ss
  (if ff (close ff))
 (princ))